create or replace package tbicds.PCK_FX_SEC AUTHID CURRENT_USER is

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

  /*
  created a database session for a user. used after a successful login to an external
  system such as MDWS to establish a session for the user in the database
  */
  procedure CreateSession(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_vWebSessionID    in varchar2,
                          po_vDBSessionID     out varchar2,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2);

  --custom to return recordsets
  type RetRefCursor is ref cursor;

  --session values
  procedure DeleteSessionValue(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               pi_vKey             in varchar2,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2);
  procedure GetSessionValue(pi_vDBSessionID     in varchar2,
                            pi_vWebSessionID    in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            pi_vKey             in varchar2,
                            po_vKeyValue        out varchar2,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2);
  procedure SetSessionValue(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            pi_vKey             in varchar2,
                            pi_vKeyValue        in varchar2,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2);

  /*audits a transaction to the syslog*/
  procedure SysLogAuditTransaction(pi_vSessionID in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   pi_nStatus          in number,
                                   pi_vAuditXML        in varchar2,
                                   po_nStatusCode      out number,
                                   po_vStatusComment   out varchar2);
                                   
  procedure DeleteAllSessionValues(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   po_nStatusCode      out number,
                                   po_vStatusComment   out varchar2);

  --auditing
  procedure AuditPageAccess(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            pi_vPageName        in varchar2,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2);

  
  --login and return a databsae session id
  procedure Login(pi_vSessionID       in varchar2,
                  pi_vSessionClientIP in varchar2,
                  pi_nUserID          in number, --not used but passed in to maintain consistant default param list
                  pi_vUserName        in varchar2,
                  pi_vPassword        in varchar2,
                  pi_vCert            in varchar2,
                  po_nUserID          out number,
                  po_vDBSessionID     out varchar2,
                  po_nTimeout         out number,
                  po_nStatusCode      out number,
                  po_vStatusComment   out varchar2);

  --login and return a databsae session id
  procedure Sign(pi_vSessionID       in varchar2,
                 pi_vSessionClientIP in varchar2,
                 pi_nUserID          in number,
                 pi_vUserName        in varchar2,
                 pi_vPassword        in varchar2,
                 po_vProviderID      out varchar2,
                 po_nUserType        out number,
                 po_nStatusCode      out number,
                 po_vStatusComment   out varchar2);

  procedure ValidatePassword(pi_vKey           in varchar2,
                             pi_nUserID        in number,
                             pi_vUserName      in varchar2,
                             pi_vOldPassword   in varchar2,
                             pi_vPassword      in varchar2,
                             pi_vCOldPassword  in varchar2,
                             pi_vCPassword     in varchar2,
                             pi_vCUserName     in varchar2,
                             pi_nResetPassword in number,
                             po_nStatusCode    out number,
                             po_vStatusComment out varchar2);

  --user change password and login
  procedure ChangePassword(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number, --not used but passed in to maintain consistant default param list
                           pi_vKey             in varchar2,
                           pi_vUserName        in varchar2,
                           pi_vOldPassword     in varchar2,
                           pi_vPassword        in varchar2,
                           pi_vCert            in varchar2,
                           pi_vCOldPassword    in varchar2,
                           pi_vCPassword       in varchar2,
                           pi_vCUserName       in varchar2,
                           po_nUserID          out number,
                           po_vDBSessionID     out varchar2,
                           po_nTimeout         out number,
                           po_nStatusCode      out number,
                           po_vStatusComment   out varchar2);

  --logoff
  procedure LogOff(pi_vSessionID       in varchar2,
                   pi_vSessionClientIP in varchar2,
                   pi_nUserID          in number,
                   po_nStatusCode      out number,
                   po_vStatusComment   out varchar2);

  --get fx_user record by encrypted uid
  procedure GetFXUserRS(pi_vSessionID       in varchar2,
                        pi_vSessionClientIP in varchar2,
                        pi_nUserID          in number,
                        pi_vEncUID          in varchar2,
                        po_nStatusCode      out number,
                        po_vStatusComment   out varchar2,
                        rs                  out RetRefCursor);

  --audit a transaction
  procedure AuditTransaction(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_vKey             in varchar2,
                             pi_vSPName          in varchar2,
                             pi_clAuditXML       in clob,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2);

  --insert a new fx_user
  procedure InsertFXUser(pi_vSessionID       in varchar2,
                         pi_vSessionClientIP in varchar2,
                         pi_nUserID          in number,
                         pi_vKey             in varchar2,
                         pi_vProviderID      in varchar2,
                         pi_vUserName        in varchar2,
                         pi_vPassword        in varchar2,
                         pi_nAccountLocked   in number,
                         pi_nAccountInactive in number,
                         
                         pi_vCOldPassword in varchar2,
                         pi_vCPassword    in varchar2,
                         pi_vCUserName    in varchar2,
                         
                         po_nFXUserID      out number,
                         po_nStatusCode    out number,
                         po_vStatusComment out varchar2);

  --update an fx_user record
  procedure UpdateFXUser(pi_vSessionID       in varchar2,
                         pi_vSessionClientIP in varchar2,
                         pi_nUserID          in number,
                         pi_nFXUserID        in number,
                         pi_vProviderID      in varchar2,
                         pi_vUserName        in varchar2,
                         pi_vPassword        in varchar2,
                         pi_nAccountLocked   in number,
                         pi_nAccountInactive in number,
                         po_nStatusCode      out number,
                         po_vStatusComment   out varchar2);

  procedure UpdateFXUserRights(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               pi_nFxUserID        in number,
                               pi_nUserType        in number,
                               pi_nUserRights      in number,
                               pi_nUserReadOnly    in number,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2);

  --update an fx_user record
  procedure UpdateFXUserPWD(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            pi_vKey             in varchar2,
                            pi_nFXUserID        in number,
                            pi_vUserName        in varchar2,
                            pi_vPassword        in varchar2,
                            pi_nAccountLocked   in number,
                            pi_nAccountInactive in number,
                            
                            pi_vCPassword in varchar2,
                            pi_vCUserName in varchar2,
                            
                            po_nStatusCode    out number,
                            po_vStatusComment out varchar2);

  --update an fx_user record
  procedure UpdateFXUserOptions(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nFXUserID        in number,
                                pi_nAccountLocked   in number,
                                pi_nAccountInactive in number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2);

  procedure GetFXUsernamePasswordRS(pi_vSessionID       in varchar2,
                                    pi_vSessionClientIP in varchar2,
                                    pi_nUserID          in number,
                                    pi_vProviderID      in varchar2,
                                    po_nStatusCode      out number,
                                    po_vStatusComment   out varchar2,
                                    rs                  out RetRefCursor);

  procedure GetFXUserIdRS(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_vProviderID      in varchar2,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor);

  procedure CheckFXUserRecRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_vProviderID      in varchar2,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor);

   procedure GetUserQuestions(pi_vSessionID       in varchar2,
  pi_vSessionClientIP in varchar2,
  pi_nUserID          in number,
  --
  pi_vUsername in varchar2,
  --                                 
  po_nStatusCode    out number,
  po_vStatusComment out varchar2,
  rs                out RetRefCursor); 

  procedure UpdateSecQuestions(pi_vSessionID       in varchar2,
  pi_vSessionClientIP in varchar2,
  pi_nUserID          in number,
  
  pi_nQuestionID_1 in number,
  pi_vAnswer_1     in varchar2,
  
  pi_nQuestionID_2 in number,
  pi_vAnswer_2     in varchar2,
  
  pi_nQuestionID_3 in number,
  pi_vAnswer_3     in varchar2,
  
  po_nStatusCode    out number,
  po_vStatusComment out varchar2);

  procedure CheckSecurityQuestions(pi_vSessionID       in varchar2,
  pi_vSessionClientIP in varchar2,
  pi_nUserID          in number,
  
  --pi_nQuestionID_1 in number,
  pi_vAnswer_1 in varchar2,
  
  --pi_nQuestionID_2 in number,
  pi_vAnswer_2 in varchar2,
  
  --pi_nQuestionID_3 in number,
  pi_vAnswer_3 in varchar2,
  
  po_nStatusCode    out number,
  po_vStatusComment out varchar2); 

  procedure ResetPassword(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_vKey             in varchar2,
                          pi_nFXUserID        in number,
                          pi_vUserName        in varchar2,
                          pi_vPassword        in varchar2,
                          pi_vCPassword       in varchar2,
                          pi_vCUserName       in varchar2,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2);

  procedure GetSecurityQuestions(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 pi_nQuestionGrp     in number,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out RetRefCursor);

end PCK_FX_SEC;
/

